{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:36:08 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMSlider, StdCtrls, Buttons, Menus, MMDIBCv, MMOscope, ExtCtrls,
  MMPanel, MMHook, MMDesign, MMConect, MMDSPObj, MMWavOut, MMWave, MMCstDlg,
  MMSystem,MMUtils,MMWaveIO, MMMemMap, MMWavIn, MMACMCvt, MMAbout;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    btnBackward: TBitBtn;
    btnForward: TBitBtn;
    btnPlay: TBitBtn;
    btnStop: TBitBtn;
    btnRecord: TBitBtn;
    TrackBar: TMMSlider;
    MMPanel1: TMMPanel;
    MMPanel2: TMMPanel;
    Oscope: TMMOscope;
    menInfo: TMenuItem;
    Label1: TLabel;
    lblPosition: TLabel;
    Label3: TLabel;
    lblLength: TLabel;
    Image1: TImage;
    Image2: TImage;
    WaveOut: TMMWaveOut;
    PlayConnector: TMMConnector;
    MMDesigner1: TMMDesigner;
    menNew: TMenuItem;
    menOpen: TMenuItem;
    menSave: TMenuItem;
    menSaveAs: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog: TMMWaveOpenDialog;
    PlayWaveFile: TMMWaveFile;
    MemMapFile: TMMMemMapFile;
    SaveDialog: TSaveDialog;
    WaveIn: TMMWaveIn;
    RecWaveFile: TMMWaveFile;
    RecConnector: TMMConnector;
    ACMConverter: TMMACMConverter;
    procedure menNewClick(Sender: TObject);
    procedure menOpenClick(Sender: TObject);
    procedure menSaveClick(Sender: TObject);
    procedure menSaveAsClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure btnRecordClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnForwardClick(Sender: TObject);
    procedure btnBackwardClick(Sender: TObject);
    procedure TrackBarChange(Sender: TObject);
    procedure WaveOutBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure TrackBarTrack(Sender: TObject);
    procedure TrackBarTrackEnd(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure WaveInStart(Sender: TObject);
    procedure WaveInStop(Sender: TObject);
    procedure WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure menInfoClick(Sender: TObject);
    procedure WaveInClose(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    PlayStart: Longint;
    Seeking,Changed: Boolean;
    TempFile,CurFile: string;

    procedure LoadFile(FName: TFileName);
    function  SaveQuery(Reload: Boolean): Boolean;
    procedure UpdateButtons;
    procedure SetNewPosition(Pos: Longint);
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   CurFile := 'Audio';
   Seeking := False;
   Changed := False;
   TempFile:= GetTempFile;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
   WaveIn.Close;
   MemMapFile.Active := False;
   DeleteFile(TempFile);
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
   CanClose := not (wisOpen in WaveIn.State);
   if CanClose then CanClose := SaveQuery(False);
end;

{------------------------------------------------------------------------------}
function TForm1.SaveQuery(Reload: Boolean): Boolean;
var
   Error: Boolean;
   Res: Word;
begin
   Result := True;
   if Changed and (RecWaveFile.Wave.DataSize > 0) then
   begin
      Res := MessageDlg('The file '+CurFile+' has been modified, save changes ?', mtConfirmation, mbYesNoCancel, 0);
      if (Res = mrYes) then
      begin
         Error := False;
         MemMapFile.Active := False;
         try
            if CurFile = 'Audio' then
            begin
               if SaveDialog.Execute then
               begin
                  PlayWaveFile.SaveToFile(SaveDialog.FileName);
                  if Reload then
                  begin
                     LoadFile(SaveDialog.FileName);
                     CurFile := SaveDialog.FileName;
                     Caption := ExtractFileName(CurFile)+ ' - AudioRecorder';
                  end;
               end
               else
               begin
                  MemMapFile.Active := True;
                  Result := False;
                  exit;
               end;
            end
            else PlayWaveFile.SaveToFile(CurFile);

         except
            Error := True;
            MemMapFile.Active := True;
            MessageDlg('Unabled to write to file', mtError, [mbOK],0);
         end;

         if not Error then
         begin
            DeleteFile(RecWaveFile.Wave.FileName);
            RecWaveFile.Wave.FreeWave;

            Changed := False;
         end
         else Result := False;
      end
      else if (Res = mrCancel) then
      begin
         Result := False;
      end
      else
      begin
         DeleteFile(RecWaveFile.Wave.FileName);
         RecWaveFile.Wave.FreeWave;

         Changed := False;
      end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.menInfoClick(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{------------------------------------------------------------------------------}
procedure TForm1.UpdateButtons;
begin
   btnBackward.Enabled := not PlayWaveFile.Wave.Empty and (TrackBar.Position > 0);
   btnForward.Enabled  := not PlayWaveFile.Wave.Empty and (TrackBar.Position < TrackBar.MaxValue);
end;

{------------------------------------------------------------------------------}
procedure TForm1.menNewClick(Sender: TObject);
begin
   { clear all loaded files and cleanup }
   if SaveQuery(False) then
   begin
      LoadFile('');
      Changed := True;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.LoadFile(FName: TFileName);
begin
   { load a new file and update all controls }
   try
      try
         MemMapFile.FileName := '';
         PlayWaveFile.Wave.FreeWave;
         PlayWaveFile.Wave.FileName := FName;
         Icon := Image1.Picture.Icon;
         if not PlayWaveFile.Wave.Empty then
         begin
            MemMapFile.FileName    := FName;
            MemMapFile.Active      := True;
            Icon := Image2.Picture.Icon;
         end;
      except
         PlayWaveFile.Wave.FreeWave;
         MemMapFile.FileName := '';
         MessageDlg('Error loading file', mtError, [mbOK],0);
      end;

   finally
      if PlayWaveFile.Wave.Empty then CurFile := 'Audio';

      Caption := ExtractFileName(CurFile)+ ' - AudioRecorder';

      Oscope.Enabled         := not (PlayWaveFile.Wave.FormatTag > WAVE_FORMAT_PCM);
      Oscope.ResetData;
      if not Oscope.Enabled then
         Oscope.Color := clBtnFace
      else
         Oscope.Color := clBlack;

      TrackBar.MaxValue      := PlayWaveFile.Wave.DataSize;
      TrackBar.Position      := 0;
      TrackBar.Enabled       := not PlayWaveFile.Wave.Empty;
      btnPlay.Enabled        := TrackBar.Enabled;
      menSave.Enabled        := TrackBar.Enabled;
      menSaveAs.Enabled      := TrackBar.Enabled;
      if TrackBar.Enabled then
         lblLength.Caption   := TimeToString(wioBytesToTime(PlayWaveFile.Wave.PWaveFormat, PlayWaveFile.Wave.DataSize))
      else
         lblLength.Caption   := TimeToString(0);

      UpdateButtons;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.menOpenClick(Sender: TObject);
begin
   { open a new file }
   if SaveQuery(True) and OpenDialog.Execute then
   begin
      Application.ProcessMessages;
      LoadFile(OpenDialog.FileName);

      CurFile := OpenDialog.FileName;
      Caption := ExtractFileName(CurFile)+ ' - AudioRecorder';

      Changed := False;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.menSaveClick(Sender: TObject);
var
   Error: Boolean;
begin
   { save changes }
   if Changed and (RecWaveFile.Wave.DataSize > 0) then
   begin
      Error := False;
      MemMapFile.Active := False;
      try
         if CurFile = 'Audio' then
         begin
            if SaveDialog.Execute then
            begin
               PlayWaveFile.SaveToFile(SaveDialog.FileName);
               LoadFile(SaveDialog.FileName);
               CurFile := SaveDialog.FileName;
               Caption := ExtractFileName(CurFile)+ ' - AudioRecorder';
            end
            else
            begin
               MemMapFile.Active := True;
               exit;
            end;
         end
         else PlayWaveFile.SaveToFile(CurFile);

      except
         Error := True;
         MemMapFile.Active := True;
         MessageDlg('Unabled to write to file', mtError, [mbOK],0);
      end;

      if not Error then
      begin
         DeleteFile(RecWaveFile.Wave.FileName);
         RecWaveFile.Wave.FreeWave;
         Changed := False;
      end;
   end
   else Changed := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.menSaveAsClick(Sender: TObject);
var
   Error: Boolean;
begin
   { save to another file }
   if SaveDialog.Execute then
   begin
      Error := False;
      try
         MemMapFile.Active := False;
         PlayWaveFile.SaveToFile(SaveDialog.FileName);
      except
         Error := True;
         MemMapFile.Active := True;
         MessageDlg('Unabled to write to file', mtError, [mbOK],0);
      end;

      if not Error then
      begin
         DeleteFile(RecWaveFile.Wave.FileName);
         RecWaveFile.Wave.FreeWave;

         LoadFile(SaveDialog.FileName);
         CurFile := SaveDialog.FileName;
         Caption := ExtractFileName(CurFile)+ ' - AudioRecorder';
         Changed := False;
      end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Exit1Click(Sender: TObject);
begin
   Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnRecordClick(Sender: TObject);
var
   Dummy: int64;
   FreeSpace: int64;
   Maxtime: Longint;

begin
   MemMapFile.FileName := '';

   DeleteFile(TempFile);

   { free the previous stuff }
   RecWaveFile.Wave.FreeWave;
   RecWaveFile.Wave.FileName := TempFile;

   { set the destination format }
   if not PlayWaveFile.Wave.Empty then
      ACMConverter.PWaveFormat := PlayWaveFile.PWaveFormat;

   { set some corresponding params for WaveIn }
   WaveIn.SampleRate := ACMConverter.PWaveFormat^.nSamplesPerSec;
   WaveIn.Mode       := TMMMode(ACMConverter.PWaveFormat^.nChannels-1);

   { get the maximal free space on the temp drive }
   GetDiskStats(RecWaveFile.Wave.FileName,FreeSpace,Dummy);

   { file can't be larger than MaxLongint bytes }
   Dummy := MaxLongint-1000000;
   if (FreeSpace > Dummy) then FreeSpace := Dummy;

   { we work in time in this demo so recalc }
   MaxTime := wioBytesToTime(RecWaveFile.PWaveFormat,FreeSpace);

   { set the maximal record time }
   WaveIn.MaxRecordTime := MaxTime;
   lblLength.Caption    := TimeToString(MaxTime);
   TrackBar.MaxValue    := MaxTime;

   Changed := True;

   { here we go... }
   WaveIn.Start;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   { if the trackbar is at the end we must reset it }
   if (Trackbar.Position >= TrackBar.MaxValue-1) then
       TrackBar.Position := 0;

   { set the start position in the file }
   PlayWaveFile.Wave.Position := TrackBar.Position;

   { save the start position for the position display }
   PlayStart := PlayWaveFile.Wave.Position;

   { let's play... }
   WaveOut.Start;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   { stop everything }
   WaveOut.Close;
   WaveIn.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.SetNewPosition(Pos: Longint);
var
   wasPlaying: Boolean;
begin
   { set a new position, if we are playing reset the device and so on }
   wasPlaying := (wosPlay in WaveOut.State);
   if wasPlaying then
   begin
      WaveOut.Pause;
   end;
   TrackBar.Position := Pos;
   PlayWaveFile.Wave.Position := Pos;
   PlayStart := Pos;
   if wasPlaying then
   begin
      WaveOut.Reset;
      WaveOut.Restart;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnForwardClick(Sender: TObject);
begin
   { move to the end... }
   SetNewPosition(TrackBar.MaxValue);
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnBackwardClick(Sender: TObject);
begin
   { ...and to the start }
   SetNewPosition(0);
end;

{------------------------------------------------------------------------------}
procedure TForm1.TrackBarChange(Sender: TObject);
begin
   { trackbar has changed, update our status display }
   if not (wisRecord in WaveIn.State) then
   begin
      UpdateButtons;
      if not PlayWaveFile.Wave.Empty then
      begin
         lblPosition.Caption := TimeToString(wioBytesToTime(PlayWaveFile.Wave.PWaveFormat, TrackBar.Position));
         { udate the Oscope, it's a bit tricky pointer stuff }
         if Oscope.Enabled then
            if (TrackBar.Position+Oscope.BytesPerScope < TrackBar.MaxValue) then
                Oscope.RefreshPCMData(PChar(MemMapFile.FileData)+PlayWaveFile.Wave.DataOffset+(TrackBar.Position div 4) * 4);
      end
      else lblPosition.Caption := TimeToString(0);
   end
   else lblPosition.Caption := TimeToString(TrackBar.Position);
end;

{------------------------------------------------------------------------------}
procedure TForm1.TrackBarTrack(Sender: TObject);
begin
   { track bar is moving, stop playing }
   Seeking := True;
   if (wosPlay in WaveOut.State) and not (wosPause in WaveOut.State) then
       WaveOut.Pause;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TrackBarTrackEnd(Sender: TObject);
begin
   { trackbar has released, set new position and restart playing }
   SetNewPosition(TrackBar.Position);
   Seeking := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   { WaveOut has played a buffer, update the trackbar }
   if not Seeking then TrackBar.Position := PlayStart+WaveOut.Position;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStart(Sender: TObject);
begin
   { playback has started }
   btnPlay.Enabled := False;
   btnStop.Enabled := True;
   btnRecord.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   { now it's stopped }
   WaveOut.Close;
   btnPlay.Enabled := True;
   btnStop.Enabled := False;
   btnRecord.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInStart(Sender: TObject);
begin
   { recording has started }
   btnPlay.Enabled := False;
   btnStop.Enabled := True;
   btnRecord.Enabled := False;
   btnBackward.Enabled := False;
   btnForward.Enabled := False;
   TrackBar.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInStop(Sender: TObject);
begin
   { and now stopped }
   WaveIn.Close;
   btnPlay.Enabled := True;
   btnStop.Enabled := False;
   btnRecord.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInClose(Sender: TObject);
begin
   { reload the recorded file }
   LoadFile(RecWaveFile.Wave.FileName);
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   { WaveIn has recorded a buffer, update the trackbar }
   TrackBar.Position := WaveIn.Position;
end;

end.
